package AppliTel;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;


public class AppliTel extends JFrame {   

	private JTextField textField;
	private JTextField textFieldSave;

	private final  int LENGTH_NUMERO = 10;

	public AppliTel() {
		super();

		build();//On initialise notre fentre
	}

	private void build(){
		setTitle("Le tlphone sonne"); //On donne un titre  l'application
		setSize(400,300); //On donne une taille  notre fentre
		setLocationRelativeTo(null); //On centre la fentre sur l'cran
		setResizable(false); //On interdit la redimensionnement de la fentre
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); //On dit  l'application de se fermer lors du clic sur la croix
		setContentPane(buildContentPane());
	}

	private JPanel buildContentPane(){
		JPanel panelHaut = new JPanel();
		panelHaut.setLayout(new BorderLayout());

		textField = new JTextField(" ", 25);
		textField.setEditable(false);
		panelHaut.add("North", textField);

		textFieldSave = new JTextField();

		JButton buttonOk = new JButton(new AnalyseNumeroAction(this, "OK"));
		panelHaut.add("Center", buttonOk);

		JPanel panelBas = new JPanel();
		panelBas.setLayout(new GridLayout(4,3));
		panelBas.setBackground(Color.white);

		JButton [] buttons = new JButton [9];
		for(int i = 0; i < buttons.length; i++) {
			buttons[i] = new JButton(new ButtonsAction(this, String.valueOf(i + 1)));
		}

		JButton buttonBis = new JButton(new ButtonBisAction(this,"Bis"));
		JButton buttonZero = new JButton(new ButtonsAction(this,"0"));
		JButton buttonReset = new JButton(new ButtonResetAction(this,"Reset"));

		for (int i = 0 ; i < buttons.length; i++) {
			panelBas.add(buttons[i]);
		}

		panelBas.add(buttonBis);
		panelBas.add(buttonZero);
		panelBas.add(buttonReset);

		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add("North", panelHaut);
		panel.add("Center", panelBas);

		return panel;
	}		

	public JTextField getTextField(){
		return textField;
	}

	public JTextField getTextFieldSave(){
		return textFieldSave;
	}

	public void analyseNumeroCompose()
	{
		if ( (textField.getText().length() != LENGTH_NUMERO)
				|| (textField.getText().charAt(0) != '0') )
		{
			textField.setText("numro incorrect");
			textFieldSave.setText("");
		}
		else 
		{
			textFieldSave.setText(textField.getText());
			textField.setText("numro appel: " + textField.getText());
		}
	}
}
